'Measures capacitance down to 0.1 pF

$crystal = 20000000
$regfile = "ATtiny2313.dat "
$hwstack = 32
$swstack = 8
$framesize = 32

Dim Timer0_mode As Byte , Period As Long , Cnt As Byte
Dim Cal_flag As Eram String * 4 , Period_c0 As Eram Long , Period_ref As Eram Long
Dim Capacity As String * 8
Dim Count As Byte

On Int0 Int0_sub Nosave
On Int1 Int1_sub Nosave

Config Clockdiv = 1

Config Portd = &B00110010
'Pind.0 = Input        'S1: calibrate

'PINd.1 = Output       'Selbsthaltung

'Pind.2 = Input        'signal input (from oscillator); Int0
'Pind.3 = Input        'signal input (from oscillator); Int1
'Pind.4 = Output       'oscillator control (reset)
'Pind.5 = Output       'OC0B out -> T1 in (internal connection; do not connect outside!)
Portd = &B00010011                                          'switch on pull-up on PD0 input & start 555

S1 Alias Pind.0

Config Lcd = 16 * 2
Config Lcdbus = 4
Config Lcdpin = Pin , Db7 = Portb.7 , Db6 = Portb.6 , Db5 = Portb.5 , Db4 = Portb.4 , E = Portb.2 , Rs = Portb.1
Cursor Off
Cls

Lcd "Elektor picoC"

Config Int0 = Falling
Config Int1 = Falling

Ocr0b = 255
Config Timer0 = Timer , Prescale = 1 , Compare B = Toggle , Clear Timer = 0
Timer0_mode = Tccr0b
Stop Timer0

Config Timer1 = Counter , Edge = Falling
Enable Interrupts

Capacity = Cal_flag
If Capacity <> "EEpC" Then Gosub Calibrate_1

Do
   Incr Count
   If Count > 15 Then Portd.1 = 0                           'Abschalten

   Debounce S1 , 0 , Calibrate , Sub
   Gosub Measure
   sbic tifr,tov1                                           'If Tifr.tov1 = 0 Then
   rjmp skip_disp

   Period = Period - Period_c0
   If Period <= 214748 Then                                 'Prevent calculation overflow
      Period = 10000 * Period
      Period = Period / Period_ref
      Capacity = Str(period)
      Home L
      Lcd "C=" ; Format(capacity , "    0.0") ; "pF"
   Else
      Gosub Disp_error_message                              'Error: C>>
   End If

Skip_disp:                                                  'End If
   Gosub Wait_and_clear
Loop

Measure:
   in r24,tccr0b                                            'If Pind.5(=OC0B) = 1 then force compare match to clear OC0B
   sbr r24,$40
   Sbic Pind , 5
   !out tccr0b,r24

   clr r24
   !out tcnt0,r24                                           'Timer0 = 0
   !out tcnt1h,r24                                          'Timer1 = 0
   !out tcnt1l,r24

   in r24,tifr
   ori r24,$EF                                              'clear Timer0&Timer1 pending interrupts
   !out eifr,r24

   in r24,eifr
   ori r24,$C0                                              'clear Int0&Int1 pending interrupts
   !out eifr,r24

   in r24,gimsk
   ori r24,$40                                              'Enable Int0 (start measurement)
   !out gimsk,r24

Measure_loop:                                               'Loop until
   in r24,gimsk                                             '   interrupts are disabled
   andi r24,$C0                                             '   (measurement finished) or
   breq Measure_ok                                          '   Timer1 overflow flag is set
   sbis tifr,tov1                                           '   (measurement lasts too long)
   rjmp Measure_loop

Measure_error:                                              'Measure error: C>>
   ldi r24,0
   !out TCCR0B,r24                                          '   Stop Timer0
   in r24,gimsk
   andi r24,$3f                                             '   Disable Int0&Int1
   !out gimsk,r24

Disp_error_message:                                         '   Display error message
   Home L
   Lcd ">>"
Return

Measure_ok:                                                 'Measurement finished OK
   in r24,tcnt0                                             '   Period = (Timer1*512+OC0B*256+Timer0)/8
   Lsr r24
   sbic pind,5
   sbr r24,$80
   in r25,tcnt1l
   in r26,tcnt1h
   lsr r26
   ror r25
   ror r24
   lsr r26
   ror r25
   ror r24
   sts {period+0},r24
   sts {period+1},r25
   sts {period+2},r26
   clr r24
   sts {period+3},r24
Return

Calibrate:
   For Cnt = 1 To 100
      Waitms 20
      If S1 = 1 Then Return
   Next

Calibrate_1:
   Home L
   Lcd "Cal:"
   Bitwait S1 , Set
   Lcd "C:0pF(S1)"
   Gosub Wait_s1

   Gosub Measure
   sbic tifr,tov1                                           'If Timer1 overflow flag is set then exit Calibrate
   rjmp wait_and_clear
   Period_c0 = Period
   Home L
   Lcd "C:1nF"
   Gosub Wait_s1

   Gosub Measure
   sbic tifr,tov1                                           'If Timer1 overflow flag is set then exit Calibrate
   rjmp wait_and_clear
   Period = Period - Period_c0
   Period_ref = Period
   Home L
   Lcd "oK" ; Spc(6)
   Cal_flag = "EEpC"

Wait_and_clear:
   Wait 1
   Home L
   Lcd Spc(16)
   Set Tifr.tov1
Return

Wait_s1:
   Do
      Debounce S1 , 0 , Wait_s1_ex
   Loop
Wait_s1_ex:
Return

Int0_sub:
   push r24
   in r24,sreg
   push r24
   ldi r24,24                                               'repeat measurement 24x
   sts {cnt},r24
   Nop
   Nop
   Nop
   lds r24,{timer0_mode}                                    'Start Timer0
   !out tccr0b,r24
   in r24,gimsk
   andi r24,$3f                                             'Disable Int0
   ori r24,$80                                              'Enable Int1
   !out gimsk,r24
   in r24,eifr
   ori r24,$C0                                              'clear Intf1 and Intf0 (clear pending external interrupts)
   !out eifr,r24
Int0_ex:
   pop r24
   !out sreg,r24
   pop r24
Return

Int1_sub:
   push r24
   in r24,sreg
   push r24
   lds r24,{cnt}                                            'count measuremens
   dec r24
   sts {cnt},r24
   brne Int1_ex                                             'allow 24 measurements before finished
   ldi r24,0
   !out TCCR0B,r24                                          'Stop Timer0
   in r24,gimsk
   andi r24,$7f                                             'Disable Int1
   !out gimsk,r24
Int1_ex:
   pop r24
   !out sreg,r24
   pop r24
Return