'Morsedecoder fr Atmel 8bit MCU, z.B. ATmega 88
'
' Copyright (C) 2010, Friedrich Lischeck
'
' Version 2.0
'
' Dieses Programm ist eine frei kopierbare Software. Sie knnen es weiter-
' vertreiben und/oder verndern, wenn Sie die Bedingungen der GNU General
' Public License wie sie in der Free Software Foundation, Version 2, oder
' spterer Ausgabe beschrieben sind, einhalten.

' Dies Programm wurde in der Hoffung entwickelt, das es Ihnen ntzt.
' Ich bernehme jedoch keine Garantie oder Gewhrleistung auf die Funktion
' des Programmes. Insbesondere hafte ich nicht fr eventuelle Schden
' und/oder Folgeschden, die sich aus der Anwendung dieses Programmes
' ergeben.

$regfile = "m88def.dat"
$crystal = 8000000
$baud = 19200

Mtaste Alias Pind.2
Config Mtaste = Input
Portd.2 = 1

Dim Idx As Byte
Dim Preload As Word
Dim Zustand As Bit
Dim Letzter_zustand As Bit
Dim Aktzeit As Long
Dim Zeit As Word
Dim Nummer As Byte

Dim Punktzeit As Word
Dim Strichzeit As Word
Dim Pause1 As Word
Dim Pause2 As Word
Dim Pause3 As Word

Dim Zeichencode As String * 10
Dim Element As String * 2
Dim Tabelle As String * 10
Dim Buchstabe As String * 2
Dim Ausgabe As String * 3
Dim Lcdausgabe As String * 20
Dim H As String * 20

Dim Zeitfeld(10) As Word
Dim Sorthilf As Word
Dim Pointer As Byte
Dim I As Byte
Dim J As Byte
Dim K As Byte

'Timer und den Teiler festlegen 128 uS / Tick
Const Faktor = 1024 / 8000000
Preload = 0
Config Timer1 = Timer , Prescale = 1024
Enable Timer1

'Config Lcdbus = 4
'Config Lcd = 16 * 2
'Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , E = Portb.5 , Rs = Portb.4
'Cls

Init:
Cls
Punktzeit = 460
Gosub Reinit


Do
Punkt1:
   Gosub Io_abfrage
   If Zustand = 1 Then
   'Signal
      If Zeit < Strichzeit Then
         'Punkt
         Element = "."
      Else
         'Strich
         Element = "-"
      End If
      Zeichencode = Zeichencode + Element
   Else
   'Pause
      If Zeit < Pause1 Then
      'Elementende
         Goto Punkt1
      End If
      'Bleiben nur noch Buchstaben- oder Wortende
      Gosub Decodieren
      Ausgabe = Buchstabe
      If Zeit < Pause3 Then
      'Buchstabenende
      Else
      'Wortende
         Ausgabe = Ausgabe + " "
      End If
      Gosub Ausgabe
      Zeichencode = ""
   End If
Loop
End

Akt_zeit:
   Zeit = Timer1
   Timer1 = Preload
Return


Io_abfrage:
' MTaste wird mit NOT invertiert, so dass Taste gedrckt: Zustand = 1 ist.
If Zeit = 0 Then
   Gosub Akt_zeit
   Zustand = Not Mtaste
End If
Letzter_zustand = Zustand
Io1:
If Mtaste = 0 Then
   If Letzter_zustand = 1 Then Goto Io1
   Zustand = 1
   'Set Led2
Else
   If Letzter_zustand = 0 Then Goto Io1
   Zustand = 0
   'Reset Led2
End If
Gosub Akt_zeit
Gosub Neuzeiten                                             'Dient der Geschwindigkeitsanpassung
Return

Neuzeiten:
Incr Pointer
If Pointer > 10 Then
   Pointer = 1
   Gosub Sortzeitfeld:
End If
Zeitfeld(pointer) = Zeit
Return

Sortzeitfeld:
For I = 1 To 10
   For J = 1 To 9
      K = J + 1
      If Zeitfeld(j) > Zeitfeld(k) Then
         Sorthilf = Zeitfeld(j)
         Zeitfeld(j) = Zeitfeld(k)
         Zeitfeld(k) = Sorthilf
      End If
   Next J
Next I
If Zeitfeld(1) > 0 Then
   Punktzeit = Zeitfeld(1)
End If
Gosub Reinit
Return

Reinit:
   Strichzeit = 2 * Punktzeit
   Pause1 = Strichzeit
   Pause3 = 5 * Punktzeit
Return


Decodieren:
Idx = 0
Buchstabe = ""
Do
   Tabelle = Lookupstr(idx , Morsealfabet)
   If Tabelle = Zeichencode Then
      Nummer = Idx + 35
      Buchstabe = Chr(nummer)
      Exit Do
   End If
   Incr Idx
   If Idx > 55 Then
      Buchstabe = "#"
      Exit Do
   End If
Loop
Return

Ausgabe:
Lcdausgabe = Lcdausgabe + Ausgabe
Nummer = Len(lcdausgabe)
Select Case Nummer
Case Is > 17
   H = Mid(lcdausgabe , 3 , 16)
Case Is > 16
   H = Mid(lcdausgabe , 2 , 16)
Case Else
   H = Lcdausgabe
End Select
   Lcdausgabe = H
Cls
Lcd Lcdausgabe
Ausgabe1:
Print Ausgabe;
Ausgabe = ""
Return

Morsealfabet:
Data "........."                                            '#
Data "........."                                            '$
Data "........."                                            '%
Data "........."                                            '&
Data ".----."                                               ' '
Data "-.--."                                                ' (
Data "-.--.-"                                               ')
Data "........."                                            '*
Data ".-.-."                                                '+
Data "--..--"                                               ',
Data "-...._"                                               '-
Data ".-.-.-"                                               '.
Data "-..-."                                                '/
Data "-----"                                                '0
Data ".----"                                                '1
Data "..---"                                                '2
Data "...--"                                                '3
Data "....-"                                                '4
Data "....."                                                '5
Data "-...."                                                '6
Data "--..."                                                '7
Data "---.."                                                '8
Data "----."                                                '9
Data "---..."                                               ':
Data "-.-.-."                                               ';
Data "........."                                            '<
Data "-...-"                                                '=
Data "........."                                            '>
Data "..--.."                                               '?
Data ".--.-."                                               '@
Data ".-"                                                   'A
Data "-..."                                                 'B
Data "-.-."                                                 'C
Data "-.."                                                  'D
Data "."                                                    'E
Data "..-."                                                 'F
Data "--."                                                  'G
Data "...."                                                 'H
Data ".."                                                   'I
Data ".---"                                                 'J
Data "-.-"                                                  'K
Data ".-.."                                                 'L
Data "--"                                                   'M
Data "-."                                                   'N
Data "---"                                                  'O
Data ".--."                                                 'P
Data "--.-"                                                 'Q
Data ".-."                                                  'R
Data "..."                                                  'S
Data "-"                                                    'T
Data "..-"                                                  'U
Data "...-"                                                 'V
Data ".--"                                                  'W
Data "-..-"                                                 'X
Data "-.--"                                                 'Y
Data "--.."                                                 'Z
