;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                 LCD-Routinen                ;;
;;                 ============                ;;
;;              (c)andreas-s@web.de            ;;
;;                                             ;;
;; 4bit-Interface                              ;;
;; DB4-DB7:       PB0-PB3                      ;;
;; RS:            PB4                          ;;
;; E:             PB5                          ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
 
;.def temp2 = r22
;.def temp3 = r23
 
;.equ LCD_PORT = PORTB
;.equ LCD_DDR  = DDRB
;.equ PIN_RS   = 4
;.equ PIN_E    = 5

;.ifndef XTAL
;.equ XTAL = 8000000
;.endif

;Cursorposition festlegen
; Temp1 =0 ist erste Zeile; Temp1>0 ist zweite Zeile
; Temp2 = Spalte (0 - 16)
lcd_cursor:
		push Temp1
		push Temp2
		push Temp3

		cpi Temp1,1
		brne Marke1
		ldi Temp1, 64
Marke1:
		ldi Temp3, 128
		add Temp1,Temp3
		add Temp1, Temp2
		rcall lcd_command
 
		pop Temp3
		pop Temp2
		pop Temp1
		
		ret
 ;sendet ein Datenbyte an das LCD
lcd_data:
           push  temp2
           push  temp3
           mov   temp2, temp1            ; "Sicherungskopie" fr
                                         ; die bertragung des 2.Nibbles
           swap  temp1                   ; Vertauschen
           andi  temp1, 0b00001111       ; oberes Nibble auf Null setzen
           sbr   temp1, 1<<PIN_RS        ; entspricht 0b00010000
           in    temp3, LCD_PORT
           andi  temp3, 0x80
           or    temp1, temp3
           out   LCD_PORT, temp1         ; ausgeben
           rcall lcd_enable              ; Enable-Routine aufrufen
                                         ; 2. Nibble, kein swap da es schon
                                         ; an der richtigen stelle ist
           andi  temp2, 0b00001111       ; obere Hlfte auf Null setzen 
           sbr   temp2, 1<<PIN_RS        ; entspricht 0b00010000
           or    temp2, temp3
           out   LCD_PORT, temp2         ; ausgeben
           rcall lcd_enable              ; Enable-Routine aufrufen
           rcall delay50us               ; Delay-Routine aufrufen

           pop   temp3
           pop   temp2
           ret                           ; zurck zum Hauptprogramm
 
 ; sendet einen Befehl an das LCD
lcd_command:                            ; wie lcd_data, nur ohne RS zu setzen
           push  temp2
           push  temp3

           mov   temp2, temp1
           swap  temp1
           andi  temp1, 0b00001111
           in    temp3, LCD_PORT
           andi  temp3, 0x80
           or    temp1, temp3
           out   LCD_PORT, temp1
           rcall lcd_enable
           andi  temp2, 0b00001111
           or    temp2, temp3
           out   LCD_PORT, temp2
           rcall lcd_enable
           rcall delay50us
 
           pop   temp3
           pop   temp2
           ret
 
 ; erzeugt den Enable-Puls
lcd_enable:
           sbi LCD_PORT, PIN_E          ; Enable high
           nop                          ; 3 Taktzyklen warten
           nop
           nop
           cbi LCD_PORT, PIN_E          ; Enable wieder low
           ret                          ; Und wieder zurck                     
 
 ; Pause nach jeder bertragung
delay50us:                              ; 50us Pause
           ldi  temp1, ( XTAL * 50 / 3 ) / 1000000
delay50us_:
           dec  temp1
           brne delay50us_
           ret                          ; wieder zurck
 
 ; Lngere Pause fr manche Befehle
delay5ms:                               ; 5ms Pause
			push Temp2
           ldi  temp1, ( XTAL * 5 / 607 ) / 1000
WGLOOP0:   ldi  temp2, $C9
WGLOOP1:   dec  temp2
           brne WGLOOP1
           dec  temp1
           brne WGLOOP0
		   pop Temp2
           ret                          ; wieder zurck
 
 ; Initialisierung: muss ganz am Anfang des Programms aufgerufen werden
lcd_init:
           push  temp1
		   push	Temp2
		   push Temp3
           in    temp1, LCD_DDR
           ori   temp1, (1<<PIN_E) | (1<<PIN_RS) | 0x0F
           out   LCD_DDR, temp1

           ldi   temp3,6
powerupwait:
           rcall delay5ms
           dec   temp3
           brne  powerupwait
           ldi   temp1,    0b00000011   ; muss 3mal hintereinander gesendet
           out   LCD_PORT, temp1        ; werden zur Initialisierung
           rcall lcd_enable             ; 1
           rcall delay5ms
           rcall lcd_enable             ; 2
           rcall delay5ms
           rcall lcd_enable             ; und 3!
           rcall delay5ms
           ldi   temp1,    0b00000010   ; 4bit-Modus einstellen
           out   LCD_PORT, temp1
           rcall lcd_enable
           rcall delay5ms
           ldi   temp1,    0b00101000   ; 4 Bot, 2 Zeilen
           rcall lcd_command
           ldi   temp1,    0b00001100   ; Display on, Cursor off
           rcall lcd_command
           ldi   temp1,    0b00000100   ; endlich fertig
           rcall lcd_command

           pop 	Temp3
		   Pop	Temp2
		   pop   temp1
           ret
 
 ; Sendet den Befehl zur Lschung des Displays
lcd_clear:
           push  temp1
           ldi   temp1,    0b00000001   ; Display lschen
           rcall lcd_command
           rcall delay5ms
           pop   temp1
           ret

 ; Cursor Home
lcd_home:
           push  temp1
           ldi   temp1,    0b00000010   ; Cursor Home
           rcall lcd_command
           rcall delay5ms
           pop   temp1
           ret

 ; Einen konstanten Text aus dem Flash Speicher
 ; ausgeben. Der Text wird mit einer 0 beendet
lcd_flash_string:
           push  temp1

lcd_flash_string_1:
           lpm   temp1, Z+
           cpi   temp1, 0
           breq  lcd_flash_string_2
           rcall  lcd_data
           rjmp  lcd_flash_string_1

lcd_flash_string_2:
           pop   temp1
           ret

 ; Eine Zahl aus dem Register temp1 dezimal ausgeben
lcd_number:
           push  temp1
           push  temp2
           push  temp3

           mov   temp2, temp1
                                  ; abzhlen wieviele Hunderter
                                          ; in der Zahl enthalten sind
           ldi   temp1, '0'
lcd_number_1:
           subi  temp2, 100
           brcs  lcd_number_2
           inc   temp1
           rjmp  lcd_number_1
                                          ;
                                          ; die Hunderterstelle ausgeben
lcd_number_2:
           rcall lcd_data
           subi  temp2, -100              ; 100 wieder dazuzhlen, da die
                                          ; vorherhgehende Schleife 100 zuviel
                                          ; abgezogen hat

                                          ; abzhlen wieviele Zehner in
                                          ; der Zahl enthalten sind
           ldi   temp1, '0'
lcd_number_3:
           subi  temp2, 10
           brcs  lcd_number_4
           inc   temp1
           rjmp  lcd_number_3

                                          ; die Zehnerstelle ausgeben
lcd_number_4:
           rcall lcd_data
           subi  temp2, -10               ; 10 wieder dazuzhlen, da die
                                          ; vorhergehende Schleife 10 zuviel
                                          ; abgezogen hat

                                          ; die brig gebliebenen Einer
                                          ; noch ausgeben
           ldi   temp1, '0'
           add   temp1, temp2
           rcall lcd_data

           pop   temp3
           pop   temp2
           pop   temp1
           ret

; eine Zahl aus dem Register temp1 hexadezimal ausgeben
lcd_number_hex:
           push  temp1

           swap  temp1
           andi  temp1, $0F
           rcall lcd_number_hex_digit

           pop   temp1
           push  temp1

           andi  temp1, $0F
           rcall lcd_number_hex_digit

           pop   temp1
           ret

lcd_number_hex_digit:
           cpi   temp1, 10
           brlt  lcd_number_hex_digit_1
           subi  temp1, -( 'A' - '9' - 1 )
lcd_number_hex_digit_1:
           subi  temp1, -'0'
           rcall  lcd_data
           ret
;************************************************************************
; 16 Bit-Zahl aus dem Registerpaar temp1 (=low), temp2 (=high) ausgeben
; die Zahl muss kleiner als 10000 sein, da die Zehntausenderstelle
; nicht bercksichtigt wird.
;
out_number:
           	push    	temp1
           	push    	temp2
		   	push		temp3
            
		   	mov temp3, temp2
		   	mov temp2, temp1
;--------------------------------------------
		   	ldi     	temp1, '0'            	; Die Tausenderstelle bestimmen
_out_tausend:
           	subi		temp2, low(1000)      	; -1000
           	sbci		temp3, high(1000)
		   	brcs    	_out_AusTau
           	inc		temp1
		   	rjmp		_out_tausend
_out_AusTau:
		   	rcall	lcd_data     	        	; und dieses Muster ausgeben

           	subi		temp2, low(-1000)      	; +1000
           	sbci		temp3, high(-1000)		; zuviel abgezogene Tausender wieder addieren
;--------------------------------------------
		   	ldi     	temp1, '0'            	; Die Hunderterstelle bestimmen
_out_hundert:
           	subi		temp2, low(100)      	; -100
           	sbci		temp3, high(100)
		   	brcs    	_out_AusHun
           	inc		temp1
		   	rjmp		_out_hundert
_out_AusHun:
		   	rcall	lcd_data     	        	; und dieses Muster ausgeben									

           	subi		temp2, low(-100)      	; +100
           	sbci		temp3, high(-100)		; zuviel abgezogene Hunderter wieder addieren
;--------------------------------------------
           	ldi     	temp1, '0'				; Die Zehnerstelle bestimmen
_out_zehner:
           	subi		temp2, low(10)      	; -10
           	sbci		temp3, high(10)
		   	brcs    	_out_AusZehn
           	inc		temp1
		   	rjmp		_out_zehner
_out_AusZehn:
		   	rcall	lcd_data     	        	; und dieses Muster ausgeben
											


           	subi		temp2, low(-10)      	; +10
           	sbci		temp3, high(-10)		; zuviel abgezogene Zehner wieder addieren
;--------------------------------------------
           	ldi     	temp1, '0'				; Die Zehnerstelle bestimmen
_out_einer:
           	subi		temp2, low(1)      		; -1
           	sbci		temp3, high(1)
		   	brcs    	_out_AusEin
           	inc		temp1
		   	rjmp		_out_einer
_out_AusEin:
		   	rcall	lcd_data     	        ; und dieses Muster ausgeben
;--------------------------------------------
           	pop     	temp3
           	pop     	temp2
 			pop			temp1	
           
		   	ret
;
;**************************************************************************



; Eine Zahl als Zeit aus dem Register temp1 ausgeben
 
lcd_zeit:
        push    temp2               ; register sichern,
                                    ; wird fr Zwsichenergebnisse gebraucht     
        ldi     temp2, '0'         
lcd_zeit_10:                
        subi    temp1, 10           ; abzhlen wieviele Zehner in
        brcs    lcd_zeit_1       	 ; der Zahl enthalten sind
        inc     temp2
        rjmp    lcd_zeit_10
lcd_zeit_1:
        push    temp1               ; den Rest sichern (http://www.mikrocontroller.net/topic/172026)
        mov     temp1,temp2         ; 
        rcall   lcd_data            ; die Zehnerstelle ausgeben
        pop     temp1               ; den Rest wieder holen
        subi    temp1, -10          ; 10 wieder dazuzhlen, da die
                                    ; vorhergehende Schleife 10 zuviel
                                    ; abgezogen hat
                                    ; das Subtrahieren von -10
                                    ; = Addition von +10 ist ein Trick
                                    ; da kein addi Befehl existiert
        ldi     temp2, '0'          ; die brig gebliebenen Einer
        add     temp1, temp2        ; noch ausgeben
        rcall   lcd_data
 
        pop     temp2               ; Register wieder herstellen
        ret

  
