; Strart pulse:	 2000us
; pause:		27830us
; 1st pulse:	  390us
; pause:		 1580us
; 2nd pulse:	  410us
; pause:		 3580us
; 3rd pulse:	  400us
; longpause:	63200us
; 
; REPEAT ONE TIME
;

delay130:
; This is a 13.0 uS delay (104 cycles @ 8MHz)
;
; sbi/cbi = 2 cycles
; rcall = 3 cycles
;
	nop
	nop
;
delay130_led_on:
	nop
	nop
	nop
;
delay130_led_off:
	nop
	nop
	ldi	Flag,30		; 1 cycle
delay130_loop:
	dec 	Flag			; 1 cycle
	brne	delay130_loop		; 2 cycle if jump to label, 1 if not
	ret				; 4 cycles


; Code executed at startup

Fernbedienung:
	push temp1
	push temp2
	push temp3
; Set PortD = IN/OUT
	ldi	R16,0b11111011
	out	DDRD,R16

	ldi		temp1,2	; Send a complete waveform 2 times

mainloop:

; Send start pulse (2000 uS)
	ldi	temp2,77		; (13 uS * 2 ) * 77 = 2002 uS
startpulse:
	sbi	PORTD,0			; LED on
	rcall	delay130_led_on		; Wait 13.0 uS
	cbi	PORTD,0			; LED off
	rcall	delay130_led_off		; wait 13.0 uS
	dec	temp2
	brne	startpulse

; Pause (27830 uS)
	ldi	temp2,237
startpause:
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	rcall	delay130
	dec	temp2
	brne	startpause

	rcall	delay130_led_off

; Send first pulse (390 uS)
	ldi	temp2,15
pulse1:
	sbi	PORTD,0			; LED on
	rcall	delay130_led_on
	cbi	PORTD,0			; LED off
	rcall	delay130_led_off
	dec	temp2
	brne	pulse1

; Pause (1580 uS)
	ldi	temp2,118
pause1:
	rcall	delay130
	dec	temp2
	brne	pause1

	ldi	temp2,5
pause1b:
	dec	temp2
	brne	pause1b


; Send 2nd pulse (410 uS)
;
; NOTE: with temp2=16 the pulse width is 416 uS (counting the last "led off" time)
; using temp2=15 and an additional "led on", it's possible to add the last 7 uS (led off) to the pause 2
; 
; temp2=15 = 390 uS +
; "led on"   =  13 uS =
; TOTAL      = 403 uS
;

	ldi	temp2,15
pulse2:
	sbi	PORTD,0			; LED on
	rcall	delay130_led_on
	cbi	PORTD,0			; LED off
	rcall	delay130_led_off
	dec	temp2
	brne	pulse2

	sbi	PORTD,0			; LED on
	rcall	delay130_led_on
	cbi	PORTD,0			; LED off

; Pause (3580 uS + 7 uS from pulse2 = 3587 uS)
	ldi	temp2,136
pause2:
	rcall	delay130
	rcall	delay130
	dec	temp2
	brne	pause2

; Send 3th pulse (400 uS) - (in real world = 403 uS)
	ldi	temp2,15
pulse3:
	sbi	PORTD,0			; LED on
	rcall	delay130_led_on
	cbi	PORTD,0			; LED off
	rcall	delay130_led_off
	dec	temp2
	brne	pulse3

	sbi	PORTD,0			; LED on
	rcall	delay130_led_on
	cbi	PORTD,0			; LED off

	dec	temp1
; No long pause before sleep
	brne	ContinueToSleep
	ret

langePause:
; Pause for 63200 uS
	ldi	temp2,239
longpause:
	ldi	temp3,10
longpause1:	
	rcall	delay130
	rcall	delay130
	dec	temp3
	brne	longpause1
	dec	temp2
	brne	longpause

; At moment : 63126 uS + 3 uS from pulse3 = 63129 uS

	ldi	temp2,5
longpause2:
	rcall	delay130
	dec	temp2
	brne	longpause2

; At moment 63193 uS + 3 uS from pulse3 = 63196 uS

	ldi	temp2,10		; 3,75 uS
longpause3:
	dec	temp2
	brne	longpause3
	
	rjmp	mainloop

ContinueToSleep:
;	sleep
;	rjmp	reset
;	rjmp	ContinueToSleep
	pop temp3
	pop temp2
	pop temp1

	ret
